/*
 * written by Steven Chaitoff
 */


/*
* PROGRAM EXECUTION
*/

// execution operations: setup capture->take capture->finish capture

Program = {

mode : '', // string indicating the general operation (full screen, timed, etc)
in_dashboard : true, // flags whether widget is being run from in dashboard
capture_file : '', // name of file that capture is to be saved to

// methods

exec : // onclick handler, kicks off image capturing
function(mode) {
	if (busy) return 0;
	busy = true;
	this.in_dashboard = dashboard_open;
	switch (this.mode = mode) {
	case 'full':
		if (this.in_dashboard) widget.openApplication('com.apple.dock');
		setTimeout(function() { Program.run(); }, 500);
		break;
	case 'time':
		Timer.start();
		break;
	case 'wndw': case 'grab':
		if (this.in_dashboard) widget.openApplication('com.apple.dock');
		this.run();
		break;
	case 'wdgt':
		if (!this.in_dashboard) widget.openApplication('com.apple.dashboardlauncher');
		this.run();
		break;
	}
	return 0;
},


run : // run utility
function() {
	System.delete_file(this.capture_file = System.temp_file(Preferences.image_format));
	widget.system('/usr/sbin/screencapture ' + this.build_flags() + ' ' + this.capture_file, this.respond);
},


respond : // after capture utility is run
function(syscall) {
	if (System.file_exists(Program.capture_file)) {
		switch (Preferences.after_capture) {
		case Preferences.after_captures[3]: // save and open
			Program.end('save', 1);
			Program.end('xprt', 1);
			break;
		case Preferences.after_captures[2]: // open in app
			Program.end('xprt', 1);
			break;
		case Preferences.after_captures[1]:// save to file
			Program.end('save', 1);
			break;
		case Preferences.after_captures[0]: // display a preview
			if (dashboard_open != Program.in_dashboard) // widget in dash but dash not showing, or widget not in dash but dash is showing
				widget.openApplication(Program.in_dashboard ? 'com.apple.dashboardlauncher' : 'com.apple.dock');
			setTimeout(function() { Context.display(Program.capture_file); }, 500);
			break;
		}
	}
	else if (Preferences.after_capture == Preferences.after_captures[0] && dashboard_open != Program.in_dashboard)
		widget.openApplication(Program.in_dashboard ? 'com.apple.dashboardlauncher' : 'com.apple.dock');
	return busy = 0;
},


end : // save buttons onclick handler
function(mode, auto) { // auto is true if this func was called programatically (by respond() above)
	switch (mode) {
	case 'rjct':
		System.delete_file(this.capture_file);
		break;
	case 'redo':
		System.delete_file(this.capture_file);
		this.exec(this.mode); // this is recursive
		break;
	case 'save':
		this.capture_file = System.move_file(this.capture_file, Preferences.save_path + '/' + Preferences.save_name + '.' + Preferences.image_format);
		break;
	case 'xprt' :
		if (dashboard_open) widget.openApplication('com.apple.dock');
		System.open_file_in_app(this.capture_file, Preferences.export_app);
		break;
	}
	if (!auto && mode != 'redo') Stretcher.stretch();
	return 0;
},


build_flags : // translates user prefs into flags for how usr/bin/screencapture will operate, according to screencapture(1)
function() {
	var flags = '-' + (Preferences.save_location == Preferences.save_locations[0] ? 'c' : '');
	switch(this.mode) {
	case 'grab':
		flags += 'i'; break;
	case 'wndw': case 'wdgt': 
		flags += 'iW'; break;
	case 'full': case 'time':
		flags += 'C'; break;
	}
	return flags += 't' + Preferences.image_format;
}

};

